Ext.data.JsonP.sol_common_forms_FormWrapper_Templates({"tagname":"class","name":"sol.common.forms.FormWrapper.Templates","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.forms.FormWrapper.js","href":"lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Templates"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"elowf":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"dateFromUnitSelector","tagname":"method","owner":"sol.common.forms.FormWrapper.Templates","id":"method-dateFromUnitSelector","meta":{}},{"name":"dateFromUnitSelectorRestrictive","tagname":"method","owner":"sol.common.forms.FormWrapper.Templates","id":"method-dateFromUnitSelectorRestrictive","meta":{}},{"name":"fileChooserVariants","tagname":"method","owner":"sol.common.forms.FormWrapper.Templates","id":"method-fileChooserVariants","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"toggle","tagname":"method","owner":"sol.common.forms.FormWrapper.Templates","id":"method-toggle","meta":{}}],"code_type":"ext_define","id":"class-sol.common.forms.FormWrapper.Templates","short_doc":"FormWrapper Templates\n\nThe FormWrapper provides a simple templating mechanism. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.forms.FormWrapper.Templates</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Templates' target='_blank'>lib_sol.common.forms.FormWrapper.js</a></div></pre><div class='doc-contents'><p>FormWrapper Templates</p>\n\n<p>The FormWrapper provides a simple templating mechanism.\nTo use a template, define a field in any state and set its template.name property\nto the name of the template:</p>\n\n<pre><code>IX_MAP_HR_CASSATIONTOGGLE: {\n  template: { name: \"toggle\", config: { ... } }\n}\n</code></pre>\n\n<p>A template is simply a function which creates a state-object using the config passed via template.config\nand returns the created state-object in the end.</p>\n\n<p>Simplest template:</p>\n\n<pre><code>myReadOnlyTemplate: function (config) {\n  var configuredTemplate;\n\n  configuredTemplate = {\n    states: {\n      stateInit: {\n        fieldProperties: {},\n        tabProperties: {}\n      }\n    }\n  }\n\n  configuredTemplate.stateInit.fieldProperties[config.name] = {readonly: config.value};\n  return configuredTemplate;\n}\n</code></pre>\n\n<p>This template <code>myReadOnlyTemplate</code> would do only one thing: set a field readonly during initialization (stateInit).</p>\n\n<p>If you define state properties in a template, they will overwrite existing states, be careful. Never overwrite the stateInit state itself, but only a field's properties in its <code>fieldProperties</code>!</p>\n\n<p>You can define a template like the one above in the OnInit function, if you define it in the extending class.</p>\n\n<pre><code>OnInit: function {\n  var me = this;\n  me.templates.myReadOnlyTemplate = me.myReadOnlyTemplate;\n}\n</code></pre>\n\n<p>Now you can use the template:</p>\n\n<pre><code>IX_GRP_HR_PERSONNEL_FIRSTNAME: {\n  template: { name: \"myReadOnlyTemplate\", config: { name: \"IX_GRP_HR_PERSONNEL_FIRSTNAME\", value: true } };\n}\n</code></pre>\n\n<p>Of course, more complex templates make more sense, since a fieldProperty can only be assigned one single template.</p>\n\n<p>You can not use a template and properties (e.g. \"hidden\", \"readonly\", ...) in a fieldProperty at the same time!</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-dateFromUnitSelector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Templates'>sol.common.forms.FormWrapper.Templates</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Templates-method-dateFromUnitSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Templates-method-dateFromUnitSelector' class='name expandable'>dateFromUnitSelector</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Template for a date which will receive its value from a unit field, its duration-selector and an optional \"terminatio...</div><div class='long'><p>Template for a date which will receive its value from a unit field, its duration-selector and an optional \"termination-Point\" selector.</p>\n\n<p>Please always name your selector unit field \"FIELDNAME_UNIT\"\nOther names are not supported yet.</p>\n\n<p>Also, it is recommended, to name your termination point field \"FIELDNAME_TP\"</p>\n\n<h3>Example config</h3>\n\n<pre><code>IX_MAP_HR_PERSONNEL_NEXTPOSSIBLEDISMISSAL: {\n  template: {\n    name: \"dateFromUnitSelector\",\n    config: {\n      recalculate: true,\n      startDateFnOrValue: undefined,  // == today\n      unitValueFieldName: \"IX_MAP_HR_PERSONNEL_PERIODOFNOTICE\",\n      unitSelectorFieldName: \"IX_MAP_HR_PERSONNEL_PERIODOFNOTICE_UNIT\",\n      terminationPointFieldName: \"IX_MAP_HR_PERSONNEL_PERIODOFNOTICE_TP\",\n      targetDateFieldName: \"IX_MAP_HR_PERSONNEL_NEXTPOSSIBLEDISMISSAL\",\n    }\n  }\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-dateFromUnitSelectorRestrictive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Templates'>sol.common.forms.FormWrapper.Templates</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Templates-method-dateFromUnitSelectorRestrictive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Templates-method-dateFromUnitSelectorRestrictive' class='name expandable'>dateFromUnitSelectorRestrictive</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Template for a date which will receive its value from a unit field and its selector. ...</div><div class='long'><p>Template for a date which will receive its value from a unit field and its selector.</p>\n\n<p>Validation messages will be displayed, if the user tries to change a field which would falsify the calculation</p>\n\n<p>e.g.\nStart date \"20170101\"</p>\n\n<p>unit \"4\"</p>\n\n<p>unitselector value \"days\"</p>\n\n<p>target date = 20170105</p>\n\n<p>Please always name your selector unit field \"FIELDNAME_UNIT\"\nOther names are not supported yet.</p>\n\n<h3>Example config</h3>\n\n<pre><code>{\n  startDateFnOrValue: \"IX_GRP_HR_PERSONNEL_DATEOFJOINING\",\n  unitValueFieldName: \"IX_MAP_HR_PERSONNEL_PROBATIONARYPERIODDURATION\",\n  unitSelectorFieldName: \"IX_MAP_HR_PERSONNEL_PROBATIONARYPERIODDURATION_UNIT\",\n  targetDateFieldName: \"IX_MAP_HR_PERSONNEL_ENDOFPROBATIONARY\",\n  validationMessage: \"Da im Feld `Ende der Probezeit` ein von der Berechnung abweichender Wert eingegeben wurde, ist dieses Feld jetzt gesperrt. Leeren Sie das Feld, wenn Sie die Berechnungsfunktion verwenden möchten!\"\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-fileChooserVariants' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Templates'>sol.common.forms.FormWrapper.Templates</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Templates-method-fileChooserVariants' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Templates-method-fileChooserVariants' class='name expandable'>fileChooserVariants</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Filechooser Variants (drag&amp;drop, filechooser, webcam picture capturing). ...</div><div class='long'><p>Filechooser Variants (drag&amp;drop, filechooser, webcam picture capturing).\nThis template has various dependencies (jar-file, libs, ...)</p>\n\n<p>In some forms, you'd maybe like to let the user select a picture. And save it for later use.\nIf so, please use the 113_capturepic_webcam \"HR\"-Form as an inspiration.</p>\n\n<p>As soon as you defined your own form having all required fields, you can use the following template</p>\n\n<h3>Example config</h3>\n\n<pre><code>{\n  name: \"personnelphotopicker\",\n  webcamName: \"personnelphotocam\",\n  webcamConfig: {\n    javaStartupButton: \"WEBCAM_JAVA\",\n    varNameBtnReset: \"JS_WEBCAM_RESET\",\n    varNameBtnSnap: \"JS_WEBCAM_SNAP\",\n    varNameContainer: \"WEBCAM_INIT\",\n    width: 540,\n    height: 390,\n    dest_width: 720,\n    dest_height: 520,\n    crop_width: 400,\n    crop_height: 520,\n    image_format: \"jpeg\",\n    jpeg_quality: 90,\n    swfURL: \"lib_webcam.swf\",\n    fps: 45,\n    showIfNoCam: true\n  },\n  dropZoneId: \"dropZone\",\n  filePickerId: \"filePicker\",\n  accept: \"image/jpeg, image/jpg, image/png\",\n  maxSize: \"3\", //Megabyte (float values possible)\n  maskNameForRule: \"Personnel file\",\n  solTypeForRule: \"PERSONNELFILE\",\n  photoReferenceField: \"HR_PERSONNEL_PHOTO_GUID\",\n  photoReferenceFieldObjId: \"HR_PERSONNEL_PHOTO_OBJID\",\n  clearPreviewField: \"JS_PICTURE_CLEAR\",\n  filePickerField: \"JS_FILEPICKER\",\n  photoConfig: {\n    maskName: \"Personnel file document\",\n    pictureName: \"Mitarbeiterfoto\"\n  }\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-toggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.FormWrapper.Templates'>sol.common.forms.FormWrapper.Templates</span><br/><a href='source/lib_sol.common.forms.FormWrapper.html#sol-common-forms-FormWrapper-Templates-method-toggle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.FormWrapper.Templates-method-toggle' class='name expandable'>toggle</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Toggle Template. ...</div><div class='long'><p>Toggle Template.</p>\n\n<h3>Example config</h3>\n\n<p>You have a form containing a toggle. Depending on which option is toggled, you want to hide, or respectively unhide fields.</p>\n\n<p>A toggle always has an \"on-state\", an \"off-state\" and an internal \"nothing toggled\" state</p>\n\n<pre><code>{\n   toggleOptionFieldName: \"IX_MAP_HR_CASSATIONTOGGLE\",\n   onValue: \"sol.hr.form.personnelfiledocument.cassationactive\",\n   offValue: \"sol.hr.form.personnelfiledocument.nocassation\",\n   onState: {\n     fieldProperties: {\n       IX_MAP_HR_PERSONNEL_CASSATIONPERIOD: {\n         hidden: false\n       },\n       IX_MAP_HR_PERSONNEL_CASSATIONPERIOD_UNIT: {\n         hidden: false\n       },\n       IX_GRP_HR_PERSONNEL_CASSATIONDATE: {\n         hidden: false\n       }\n     }\n   },\n   offState: {\n     fieldProperties: {\n       IX_MAP_HR_PERSONNEL_CASSATIONPERIOD: {\n         hidden: true\n       },\n       IX_MAP_HR_PERSONNEL_CASSATIONPERIOD_UNIT: {\n         hidden: true\n       },\n       IX_GRP_HR_PERSONNEL_CASSATIONDATE: {\n         hidden: true,\n         value: \"\"\n       }\n     }\n   }\n }\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{"elowf":true}});